<!doctype html>
    <html lang="fr">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

        <title>Paiement en ligne | Réunion Pathologie</title>
    </head>
    <body>

        <div class="container text-center">
            <h1>Récapitulatif de votre</h1>
            
            <?php
            /**
             * Toolbox initialisation, using Systempay account informations
             * Required : ShopID + CERTIFICATE + platform URL
             */
            $toolbox = require "config.php";
            
            /**
             * Payment arguments
             * If none is mentioned, defaults will be used
             * You can check defaults and formats : vads-payment-php\lib\payzenFormToolbox.php  in function "getFormFields"
             */
            
            if (isset($_POST['amount'])) {
            
                $amount = str_replace(',','.',$_POST['amount']) + 0.00;
                //echo $amount;
            
              if (is_float($amount)) {
                $amount_in_cents = floatval($amount) * 100;
              
                $orderId = $_POST['orderId'];
                $firstName = $_POST['firstName'];
                $lastName = $_POST['lastName'];
                $email = $_POST['email'];
                $phoneNumber = $_POST['phoneNumber'];
                
                $args = array(
                  "vads_amount" => $amount_in_cents,//The amount of the transaction presented in the smallest unit of the currency (cents for Euro).
                  "vads_currency" => "978", // An ISO 4217 numerical code of the payment currency.
                  "vads_order_id" => $orderID,
                  "vads_cust_first_name" => $firstName,
                  "vads_cust_last_name" => $lastName,
                  "vads_cust_email" => $email,
                  "vads_cust_phone" => $phoneNumber, 
                );
              
                //var_dump($args);
              
                echo "Procéder au réglement de la facture n°$orderId d'un montant de $amount"."&euro; au nom de $firstName $lastName";
                
                /**
                 * Retrieve FORM DATA
                 */
                $formData = $toolbox->getFormData($args);
              
                /**
                 * Output the form in html
                 */
                $form = '<form action="'.$formData['form']['action'].'" method="'.$formData['form']['method'].'" accept-charset="'.$formData['form']['accept-charset'].'" target="paymentFrame">';
                  foreach ($formData['fields'] as $name => $value) {
                    $form .= '<input type="hidden" readonly="readonly"  name="'.$name.'" value="'.$value.'" />';
                  }
                  $form .= '<input type="submit" class="mt-2 btn btn-primary" name="pay-submit" value="Confirmer et procéder au paiement"/>';
                $form .= '</form>';
              
                echo $form;
              }
              else {
                // error, payment can't be proceed
                echo "error";
              }
            
            }
            else { 
              // error, payment can't be proceed
              echo "error";
            }
            
            ?>
        </div>
    </body>
</html>



