

CREATE TABLE `JE3LZx3e_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `JE3LZx3e_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO JE3LZx3e_comments VALUES("1","1","Un commentateur WordPress","wapuu@wordpress.example","https://wordpress.org/","","2020-05-11 09:56:01","2020-05-11 07:56:01","Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.","0","1","","","0","0");



CREATE TABLE `JE3LZx3e_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `JE3LZx3e_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=290 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO JE3LZx3e_options VALUES("1","siteurl","https://preprod.reunion-pathologie.re","yes");
INSERT INTO JE3LZx3e_options VALUES("2","home","https://preprod.reunion-pathologie.re","yes");
INSERT INTO JE3LZx3e_options VALUES("3","blogname","Réunion Pathologie","yes");
INSERT INTO JE3LZx3e_options VALUES("4","blogdescription","Site internet du Laboratoire Réunion Pathologie à Saint-Pierre, Île de La Réunion","yes");
INSERT INTO JE3LZx3e_options VALUES("5","users_can_register","0","yes");
INSERT INTO JE3LZx3e_options VALUES("6","admin_email","info@rekursiv.fr","yes");
INSERT INTO JE3LZx3e_options VALUES("7","start_of_week","1","yes");
INSERT INTO JE3LZx3e_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO JE3LZx3e_options VALUES("9","use_smilies","1","yes");
INSERT INTO JE3LZx3e_options VALUES("10","require_name_email","1","yes");
INSERT INTO JE3LZx3e_options VALUES("11","comments_notify","1","yes");
INSERT INTO JE3LZx3e_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO JE3LZx3e_options VALUES("13","rss_use_excerpt","1","yes");
INSERT INTO JE3LZx3e_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO JE3LZx3e_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO JE3LZx3e_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO JE3LZx3e_options VALUES("17","mailserver_port","110","yes");
INSERT INTO JE3LZx3e_options VALUES("18","default_category","1","yes");
INSERT INTO JE3LZx3e_options VALUES("19","default_comment_status","closed","yes");
INSERT INTO JE3LZx3e_options VALUES("20","default_ping_status","open","yes");
INSERT INTO JE3LZx3e_options VALUES("21","default_pingback_flag","","yes");
INSERT INTO JE3LZx3e_options VALUES("22","posts_per_page","10","yes");
INSERT INTO JE3LZx3e_options VALUES("23","date_format","j F Y","yes");
INSERT INTO JE3LZx3e_options VALUES("24","time_format","g:i A","yes");
INSERT INTO JE3LZx3e_options VALUES("25","links_updated_date_format","j F Y G \\h i \\m\\i\\n","yes");
INSERT INTO JE3LZx3e_options VALUES("26","comment_moderation","1","yes");
INSERT INTO JE3LZx3e_options VALUES("27","moderation_notify","1","yes");
INSERT INTO JE3LZx3e_options VALUES("28","permalink_structure","/%category%/%postname%/","yes");
INSERT INTO JE3LZx3e_options VALUES("29","rewrite_rules","a:127:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:48:\"categorie/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:43:\"categorie/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:24:\"categorie/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:36:\"categorie/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:18:\"categorie/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:48:\"mot-cle/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:43:\"mot-cle/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:24:\"mot-cle/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:36:\"mot-cle/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:18:\"mot-cle/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:54:\"portfolio-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:49:\"portfolio-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:30:\"portfolio-tag/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_tag=$matches[1]&embed=true\";s:42:\"portfolio-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_tag=$matches[1]&paged=$matches[2]\";s:24:\"portfolio-tag/([^/]+)/?$\";s:35:\"index.php?portfolio_tag=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:31:\".+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\".+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\".+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"(.+?)/([^/]+)/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:26:\"(.+?)/([^/]+)/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:46:\"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:41:\"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:34:\"(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:41:\"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:30:\"(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:20:\".+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\".+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\".+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:14:\"(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:26:\"(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:33:\"(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:8:\"(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}","yes");
INSERT INTO JE3LZx3e_options VALUES("30","hack_file","0","yes");
INSERT INTO JE3LZx3e_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO JE3LZx3e_options VALUES("32","moderation_keys","","no");
INSERT INTO JE3LZx3e_options VALUES("33","active_plugins","a:1:{i:0;s:31:\"jupiterx-core/jupiterx-core.php\";}","yes");
INSERT INTO JE3LZx3e_options VALUES("34","category_base","/categorie","yes");
INSERT INTO JE3LZx3e_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO JE3LZx3e_options VALUES("36","comment_max_links","2","yes");
INSERT INTO JE3LZx3e_options VALUES("37","gmt_offset","4","yes");
INSERT INTO JE3LZx3e_options VALUES("38","default_email_category","1","yes");
INSERT INTO JE3LZx3e_options VALUES("39","recently_edited","","no");
INSERT INTO JE3LZx3e_options VALUES("40","template","jupiterx","yes");
INSERT INTO JE3LZx3e_options VALUES("41","stylesheet","jupiterx-child","yes");
INSERT INTO JE3LZx3e_options VALUES("42","comment_whitelist","1","yes");
INSERT INTO JE3LZx3e_options VALUES("43","blacklist_keys","","no");
INSERT INTO JE3LZx3e_options VALUES("44","comment_registration","","yes");
INSERT INTO JE3LZx3e_options VALUES("45","html_type","text/html","yes");
INSERT INTO JE3LZx3e_options VALUES("46","use_trackback","0","yes");
INSERT INTO JE3LZx3e_options VALUES("47","default_role","subscriber","yes");
INSERT INTO JE3LZx3e_options VALUES("48","db_version","47018","yes");
INSERT INTO JE3LZx3e_options VALUES("49","uploads_use_yearmonth_folders","","yes");
INSERT INTO JE3LZx3e_options VALUES("50","upload_path","","yes");
INSERT INTO JE3LZx3e_options VALUES("51","blog_public","0","yes");
INSERT INTO JE3LZx3e_options VALUES("52","default_link_category","2","yes");
INSERT INTO JE3LZx3e_options VALUES("53","show_on_front","posts","yes");
INSERT INTO JE3LZx3e_options VALUES("54","tag_base","/mot-cle","yes");
INSERT INTO JE3LZx3e_options VALUES("55","show_avatars","","yes");
INSERT INTO JE3LZx3e_options VALUES("56","avatar_rating","G","yes");
INSERT INTO JE3LZx3e_options VALUES("57","upload_url_path","","yes");
INSERT INTO JE3LZx3e_options VALUES("58","thumbnail_size_w","200","yes");
INSERT INTO JE3LZx3e_options VALUES("59","thumbnail_size_h","200","yes");
INSERT INTO JE3LZx3e_options VALUES("60","thumbnail_crop","1","yes");
INSERT INTO JE3LZx3e_options VALUES("61","medium_size_w","400","yes");
INSERT INTO JE3LZx3e_options VALUES("62","medium_size_h","400","yes");
INSERT INTO JE3LZx3e_options VALUES("63","avatar_default","mystery","yes");
INSERT INTO JE3LZx3e_options VALUES("64","large_size_w","2000","yes");
INSERT INTO JE3LZx3e_options VALUES("65","large_size_h","2000","yes");
INSERT INTO JE3LZx3e_options VALUES("66","image_default_link_type","","yes");
INSERT INTO JE3LZx3e_options VALUES("67","image_default_size","","yes");
INSERT INTO JE3LZx3e_options VALUES("68","image_default_align","","yes");
INSERT INTO JE3LZx3e_options VALUES("69","close_comments_for_old_posts","1","yes");
INSERT INTO JE3LZx3e_options VALUES("70","close_comments_days_old","14","yes");
INSERT INTO JE3LZx3e_options VALUES("71","thread_comments","1","yes");
INSERT INTO JE3LZx3e_options VALUES("72","thread_comments_depth","5","yes");
INSERT INTO JE3LZx3e_options VALUES("73","page_comments","","yes");
INSERT INTO JE3LZx3e_options VALUES("74","comments_per_page","50","yes");
INSERT INTO JE3LZx3e_options VALUES("75","default_comments_page","newest","yes");
INSERT INTO JE3LZx3e_options VALUES("76","comment_order","asc","yes");
INSERT INTO JE3LZx3e_options VALUES("77","sticky_posts","a:0:{}","yes");
INSERT INTO JE3LZx3e_options VALUES("78","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("79","widget_text","a:0:{}","yes");
INSERT INTO JE3LZx3e_options VALUES("80","widget_rss","a:0:{}","yes");
INSERT INTO JE3LZx3e_options VALUES("81","uninstall_plugins","a:0:{}","no");
INSERT INTO JE3LZx3e_options VALUES("82","timezone_string","","yes");
INSERT INTO JE3LZx3e_options VALUES("83","page_for_posts","0","yes");
INSERT INTO JE3LZx3e_options VALUES("84","page_on_front","0","yes");
INSERT INTO JE3LZx3e_options VALUES("85","default_post_format","0","yes");
INSERT INTO JE3LZx3e_options VALUES("86","link_manager_enabled","0","yes");
INSERT INTO JE3LZx3e_options VALUES("87","finished_splitting_shared_terms","1","yes");
INSERT INTO JE3LZx3e_options VALUES("88","site_icon","0","yes");
INSERT INTO JE3LZx3e_options VALUES("89","medium_large_size_w","768","yes");
INSERT INTO JE3LZx3e_options VALUES("90","medium_large_size_h","0","yes");
INSERT INTO JE3LZx3e_options VALUES("91","wp_page_for_privacy_policy","3","yes");
INSERT INTO JE3LZx3e_options VALUES("92","show_comments_cookies_opt_in","1","yes");
INSERT INTO JE3LZx3e_options VALUES("93","admin_email_lifespan","1604735760","yes");
INSERT INTO JE3LZx3e_options VALUES("94","initial_db_version","47018","yes");
INSERT INTO JE3LZx3e_options VALUES("95","JE3LZx3e_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO JE3LZx3e_options VALUES("96","fresh_site","1","yes");
INSERT INTO JE3LZx3e_options VALUES("97","WPLANG","fr_FR","yes");
INSERT INTO JE3LZx3e_options VALUES("98","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("99","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("100","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("101","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("102","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("103","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:17:\"sidebar_secondary\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO JE3LZx3e_options VALUES("104","cron","a:5:{i:1589529361;a:5:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1589529402;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1589529403;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1589874961;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO JE3LZx3e_options VALUES("105","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("106","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("107","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("108","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("109","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("110","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("111","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("112","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("113","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("115","recovery_keys","a:0:{}","yes");
INSERT INTO JE3LZx3e_options VALUES("284","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1589521824;s:7:\"checked\";a:5:{s:14:\"jupiterx-child\";s:5:\"1.0.0\";s:8:\"jupiterx\";s:6:\"1.18.1\";s:14:\"twentynineteen\";s:3:\"1.5\";s:15:\"twentyseventeen\";s:3:\"2.3\";s:12:\"twentytwenty\";s:3:\"1.2\";}s:8:\"response\";a:1:{s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.1.3.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}}s:12:\"translations\";a:0:{}}","no");
INSERT INTO JE3LZx3e_options VALUES("126","_site_transient_timeout_browser_d76066cd1ceaaa68be710a0b28118a46","1589788603","no");
INSERT INTO JE3LZx3e_options VALUES("278","_site_transient_timeout_theme_roots","1589523619","no");
INSERT INTO JE3LZx3e_options VALUES("279","_site_transient_theme_roots","a:5:{s:14:\"jupiterx-child\";s:7:\"/themes\";s:8:\"jupiterx\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:12:\"twentytwenty\";s:7:\"/themes\";}","no");
INSERT INTO JE3LZx3e_options VALUES("122","theme_mods_twentytwenty","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1589283112;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}","yes");
INSERT INTO JE3LZx3e_options VALUES("127","_site_transient_browser_d76066cd1ceaaa68be710a0b28118a46","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"81.0.4044.138\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO JE3LZx3e_options VALUES("128","_site_transient_timeout_php_check_80bc207537711bbc111e88c4ab5d2dc5","1589788603","no");
INSERT INTO JE3LZx3e_options VALUES("129","_site_transient_php_check_80bc207537711bbc111e88c4ab5d2dc5","a:5:{s:19:\"recommended_version\";s:3:\"7.3\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no");
INSERT INTO JE3LZx3e_options VALUES("275","_transient_timeout_jupiterx_tgmpa_plugins","1589565017","no");
INSERT INTO JE3LZx3e_options VALUES("276","_transient_jupiterx_tgmpa_plugins","a:24:{i:0;a:14:{s:2:\"id\";i:37690;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jupiter X Core\";s:4:\"slug\";s:13:\"jupiterx-core\";s:8:\"basename\";s:31:\"jupiterx-core/jupiterx-core.php\";s:7:\"img_url\";s:100:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiterx-core-icon.png\";s:4:\"desc\";s:107:\"Enables the customizer settings in Jupiter X. Also, some other theme functionalities depend on this plugin.\";s:6:\"source\";s:102:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/jupiterx-core-v1.16.0.zip\";s:7:\"version\";s:6:\"1.16.0\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:63:\"https://themes.artbees.net/docs/jupiter-x-core-plugin-overview/\";s:11:\"is_callable\";s:13:\"JupiterX_Core\";}i:1;a:12:{s:2:\"id\";i:37695;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:22:\"Advanced Custom Fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:8:\"basename\";s:30:\"advanced-custom-fields/acf.php\";s:7:\"img_url\";s:90:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:11:\"is_callable\";s:3:\"ACF\";}i:2;a:12:{s:2:\"id\";i:37698;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:8:\"basename\";s:23:\"elementor/elementor.php\";s:7:\"img_url\";s:96:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-elementor-icon.png\";s:4:\"desc\";s:162:\"The default page builder with Jupiter X. It allows you to edit the pages in a real WYSIWYG editor. Currently known as the most advanced page builder in the world.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:74:\"https://help.artbees.net/getting-started/plugins/elementor-plugin-overview\";s:11:\"is_callable\";s:16:\"Elementor\\Plugin\";}i:3;a:15:{s:2:\"id\";i:37586;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:5:\"Raven\";s:4:\"slug\";s:5:\"raven\";s:8:\"basename\";s:15:\"raven/raven.php\";s:7:\"img_url\";s:92:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-raven-icon.png\";s:4:\"desc\";s:189:\"20+ new elements exclusively developed by Artbees for Elementor. Also, Header, Footer and custom post type templates in the Free version of Elementor will be available by using this plugin.\";s:6:\"source\";s:93:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/raven-v1.9.4.zip\";s:7:\"version\";s:5:\"1.9.4\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:70:\"https://help.artbees.net/getting-started/plugins/raven-plugin-overview\";s:11:\"is_callable\";s:12:\"Raven\\Plugin\";s:8:\"releases\";O:8:\"stdClass\":2:{s:6:\"item-0\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:1:\"I\";s:15:\"_version_number\";s:5:\"1.3.0\";}s:6:\"item-1\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:2:\"II\";s:15:\"_version_number\";s:5:\"1.3.1\";}}}i:4;a:15:{s:2:\"id\";i:37701;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:12:\"Jet Elements\";s:4:\"slug\";s:12:\"jet-elements\";s:8:\"basename\";s:29:\"jet-elements/jet-elements.php\";s:7:\"img_url\";s:99:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-elements-icon.png\";s:4:\"desc\";s:62:\"Adds different Elements and widgets to Elementor page builder.\";s:6:\"source\";s:100:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-elements.2.2.14.zip\";s:7:\"version\";s:6:\"2.2.14\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/jetelements-plugin-overview/\";s:11:\"is_callable\";s:12:\"Jet_Elements\";s:10:\"label_type\";s:8:\"Optional\";}i:5;a:15:{s:2:\"id\";i:37706;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Blog\";s:4:\"slug\";s:8:\"jet-blog\";s:8:\"basename\";s:21:\"jet-blog/jet-blog.php\";s:7:\"img_url\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-blog-icon.png\";s:4:\"desc\";s:90:\"Adds advanced widgets to Elementor and let you build a powerful blog and magazine website.\";s:6:\"source\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-blog.2.2.5.zip\";s:7:\"version\";s:5:\"2.2.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetblog-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Blog\";s:10:\"label_type\";s:8:\"Optional\";}i:6;a:15:{s:2:\"id\";i:37711;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Menu\";s:4:\"slug\";s:8:\"jet-menu\";s:8:\"basename\";s:21:\"jet-menu/jet-menu.php\";s:7:\"img_url\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-menu-icon.png\";s:4:\"desc\";s:52:\"Advanced mega menu addon for Elementor page builder.\";s:6:\"source\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-menu.2.0.4.zip\";s:7:\"version\";s:5:\"2.0.4\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetmenu-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Menu\";s:10:\"label_type\";s:8:\"Optional\";}i:7;a:15:{s:2:\"id\";i:37716;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Jet Popup\";s:4:\"slug\";s:9:\"jet-popup\";s:8:\"basename\";s:23:\"jet-popup/jet-popup.php\";s:7:\"img_url\";s:96:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-popup-icon.png\";s:4:\"desc\";s:55:\"The advanced plugin for creating popups with Elementor.\";s:6:\"source\";s:96:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/03/jet-popup.1.3.1.zip\";s:7:\"version\";s:5:\"1.3.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:57:\"https://themes.artbees.net/docs/jetpopup-plugin-overview/\";s:11:\"is_callable\";s:9:\"Jet_Popup\";s:10:\"label_type\";s:8:\"Optional\";}i:8;a:15:{s:2:\"id\";i:37721;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Tabs\";s:4:\"slug\";s:8:\"jet-tabs\";s:8:\"basename\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"img_url\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tabs-icon.png\";s:4:\"desc\";s:56:\"Advanced Tabs and Accordions for Elementor Page Builder.\";s:6:\"source\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/jet-tabs.2.1.4.zip\";s:7:\"version\";s:5:\"2.1.4\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jettabs-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Tabs\";s:10:\"label_type\";s:8:\"Optional\";}i:9;a:15:{s:2:\"id\";i:37726;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jet WooBuilder\";s:4:\"slug\";s:15:\"jet-woo-builder\";s:8:\"basename\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"img_url\";s:101:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-woobuilder-icon.png\";s:4:\"desc\";s:131:\"Custom shop templates for WooCommerce. Adds some widgets to Elementor that can be used inside and outside of WooCommerce templates.\";s:6:\"source\";s:102:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/03/jet-woo-builder.1.6.2.zip\";s:7:\"version\";s:5:\"1.6.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/jetwoobuilder-plugin-overview/\";s:11:\"is_callable\";s:15:\"Jet_Woo_Builder\";s:10:\"label_type\";s:8:\"Optional\";}i:10;a:15:{s:2:\"id\";i:37731;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Tricks\";s:4:\"slug\";s:10:\"jet-tricks\";s:8:\"basename\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"img_url\";s:97:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tricks-icon.png\";s:4:\"desc\";s:124:\"Use different eye-catching stylish animation effects and let your content become truly alive with outstanding visual tricks.\";s:6:\"source\";s:97:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/03/jet-tricks.1.2.7.zip\";s:7:\"version\";s:5:\"1.2.7\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jettricks-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Tricks\";s:10:\"label_type\";s:8:\"Optional\";}i:11;a:15:{s:2:\"id\";i:37736;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Engine\";s:4:\"slug\";s:10:\"jet-engine\";s:8:\"basename\";s:25:\"jet-engine/jet-engine.php\";s:7:\"img_url\";s:97:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-engine-icon.png\";s:4:\"desc\";s:146:\"Create and manage custom post types, listings and booking forms for them. Completely compatible with Jupiter X Custom Post Type templates feature.\";s:6:\"source\";s:98:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-engine-v2.3.5.zip\";s:7:\"version\";s:5:\"2.3.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jetengine-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Engine\";s:10:\"label_type\";s:8:\"Optional\";}i:12;a:15:{s:2:\"id\";i:37741;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Jet SmartFilters\";s:4:\"slug\";s:17:\"jet-smart-filters\";s:8:\"basename\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"img_url\";s:103:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-smartfilters-icon.png\";s:4:\"desc\";s:107:\"Adds easy-to-use AJAX filters and widgets to Elementor so you can easily manage your listings and products.\";s:6:\"source\";s:104:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-smart-filters.1.7.2.zip\";s:7:\"version\";s:5:\"1.7.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:64:\"https://themes.artbees.net/docs/jetsmartfilters-plugin-overview/\";s:11:\"is_callable\";s:17:\"Jet_Smart_Filters\";s:10:\"label_type\";s:8:\"Optional\";}i:13;a:14:{s:2:\"id\";i:37746;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:40:\"WPBakery Page Builder (Modified Version)\";s:4:\"slug\";s:17:\"js_composer_theme\";s:8:\"basename\";s:33:\"js_composer_theme/js_composer.php\";s:7:\"img_url\";s:99:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-js_composer_theme.svg\";s:4:\"desc\";s:140:\"Another page builder with Jupiter X. It can work along side Elementor. Best for the websites that want to migrate from Jupiter to Jupiter X.\";s:6:\"source\";s:113:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/jupiterx_js_composer_theme.6.0.5.zip\";s:7:\"version\";s:5:\"6.0.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:10:\"Vc_Manager\";s:10:\"label_type\";s:8:\"Optional\";}i:14;a:14:{s:2:\"id\";i:37751;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Jupiter Donut\";s:4:\"slug\";s:13:\"jupiter-donut\";s:8:\"basename\";s:31:\"jupiter-donut/jupiter-donut.php\";s:7:\"img_url\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiter-donut.png\";s:4:\"desc\";s:205:\"80+ shortcodes for WPBakery Page Builder. These shortcodes were available in Jupiter and are necessary if you are migrating your theme from Jupiter to Jupiter X and still want to use WPBakery Page Builder.\";s:6:\"source\";s:101:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/jupiter-donut-v1.0.6.zip\";s:7:\"version\";s:5:\"1.0.6\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:13:\"Jupiter_Donut\";s:10:\"label_type\";s:8:\"Optional\";}i:15;a:15:{s:2:\"id\";i:37755;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:8:\"basename\";s:34:\"advanced-custom-fields-pro/acf.php\";s:7:\"img_url\";s:90:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:6:\"source\";s:114:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/advanced-custom-fields-pro-v5.8.7.zip\";s:7:\"version\";s:5:\"5.8.7\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:91:\"https://help.artbees.net/getting-started/plugins/advanced-custom-fields-pro-plugin-overview\";s:11:\"is_callable\";s:7:\"acf_pro\";s:10:\"label_type\";s:8:\"Optional\";}i:16;a:13:{s:2:\"id\";i:37759;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:23:\"Menu Icons by ThemeIsle\";s:4:\"slug\";s:10:\"menu-icons\";s:8:\"basename\";s:25:\"menu-icons/menu-icons.php\";s:7:\"img_url\";s:92:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-menu-icons.png\";s:4:\"desc\";s:30:\"Adds icons to your menu items.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:59:\"https://themes.artbees.net/docs/menu-icons-plugin-overview/\";s:11:\"is_callable\";s:10:\"Menu_Icons\";s:10:\"label_type\";s:8:\"Optional\";}i:17;a:15:{s:2:\"id\";i:37762;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:8:\"basename\";s:23:\"revslider/revslider.php\";s:7:\"img_url\";s:91:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/slider-revolution-icon.png\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:96:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/revslider.6.1.5.zip\";s:7:\"version\";s:5:\"6.1.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:66:\"https://themes.artbees.net/docs/slider-revolution-plugin-overview/\";s:11:\"is_callable\";s:14:\"RevSliderFront\";s:10:\"label_type\";s:8:\"Optional\";}i:18;a:15:{s:2:\"id\";i:37767;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Master Slider\";s:4:\"slug\";s:12:\"masterslider\";s:8:\"basename\";s:29:\"masterslider/masterslider.php\";s:7:\"img_url\";s:100:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-master-slider-icon.jpg\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:100:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/masterslider.3.2.14.zip\";s:7:\"version\";s:6:\"3.2.14\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/master-slider-plugin-overview/\";s:11:\"is_callable\";s:13:\"Master_Slider\";s:10:\"label_type\";s:8:\"Optional\";}i:19;a:15:{s:2:\"id\";i:37769;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"LayerSlider WP\";s:4:\"slug\";s:11:\"LayerSlider\";s:8:\"basename\";s:27:\"LayerSlider/layerslider.php\";s:7:\"img_url\";s:99:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-layer-slider-icon.png\";s:4:\"desc\";s:108:\"Popular advanced Slider plugin. Build and publish your sliders on your website. License is \"In-Stock Usage\".\";s:6:\"source\";s:106:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/jupiter_LayerSlider.6.9.2.zip\";s:7:\"version\";s:5:\"6.9.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:61:\"https://themes.artbees.net/docs/layer-slider-plugin-overview/\";s:11:\"is_callable\";s:9:\"LS_Config\";s:10:\"label_type\";s:8:\"Optional\";}i:20;a:13:{s:2:\"id\";i:37772;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:8:\"basename\";s:27:\"woocommerce/woocommerce.php\";s:7:\"img_url\";s:98:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-woocommerce-icon.png\";s:4:\"desc\";s:131:\"Create and manage your e-commerce website with this plugin. After activating, the Shop section in the Customizer will be available.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/woocommerce-plugin-overview/\";s:11:\"is_callable\";s:11:\"WooCommerce\";s:10:\"label_type\";s:8:\"Optional\";}i:21;a:13:{s:2:\"id\";i:37774;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:24:\"Customizer Export/Import\";s:4:\"slug\";s:24:\"customizer-export-import\";s:8:\"basename\";s:53:\"customizer-export-import/customizer-export-import.php\";s:7:\"img_url\";s:111:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-export-import-icon.png\";s:4:\"desc\";s:112:\"Adds the Export and import option to the Customizer. Useful for theme migrations and moving to the child themes.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:73:\"https://themes.artbees.net/docs/customizer-export-import-plugin-overview/\";s:11:\"is_callable\";s:8:\"CEI_Core\";s:10:\"label_type\";s:8:\"Optional\";}i:22;a:13:{s:2:\"id\";i:37776;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Customizer Reset\";s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:8:\"basename\";s:47:\"customizer-reset-by-wpzoom/customizer-reset.php\";s:7:\"img_url\";s:103:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-reset-icon.png\";s:4:\"desc\";s:107:\"Reset theme customizations made via WordPress Customizer. Useful for troubleshooting the customizer issues.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:65:\"https://themes.artbees.net/docs/customizer-reset-plugin-overview/\";s:11:\"is_callable\";s:21:\"ZOOM_Customizer_Reset\";s:10:\"label_type\";s:8:\"Optional\";}i:23;a:13:{s:2:\"id\";i:45885;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"WunderWP\";s:4:\"slug\";s:8:\"wunderwp\";s:8:\"basename\";s:21:\"wunderwp/wunderwp.php\";s:7:\"img_url\";s:89:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/2020/02/wunderwp_plugin_icon.png\";s:4:\"desc\";s:151:\"Save and reuse your Elementor styles or templates in the WunderWP Cloud or use readymade styles to quickly beautify your Elementor pages. All for free!\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:21:\"https://wunderwp.com/\";s:11:\"is_callable\";s:8:\"WunderWP\";s:10:\"label_type\";s:8:\"Optional\";}}","no");
INSERT INTO JE3LZx3e_options VALUES("133","can_compress_scripts","1","no");
INSERT INTO JE3LZx3e_options VALUES("188","recently_activated","a:0:{}","yes");
INSERT INTO JE3LZx3e_options VALUES("206","jupiterx","a:22:{s:13:\"theme_version\";s:6:\"1.18.1\";s:23:\"mods_migrated_from_lite\";b:1;s:21:\"theme_current_version\";s:6:\"1.18.1\";s:7:\"api_key\";s:64:\"d8767d92e0bc41da5e2c48753f30e174dc8fe09a1b2c732f812679b8d47a1f39\";s:8:\"dev_mode\";s:1:\"1\";s:13:\"cache_busting\";s:1:\"1\";s:11:\"svg_support\";s:1:\"0\";s:19:\"google_analytics_id\";s:0:\"\";s:30:\"google_analytics_anonymization\";s:1:\"1\";s:22:\"adobe_fonts_project_id\";s:0:\"\";s:25:\"tracking_codes_after_head\";s:0:\"\";s:26:\"tracking_codes_before_head\";s:0:\"\";s:25:\"tracking_codes_after_body\";s:0:\"\";s:26:\"tracking_codes_before_body\";s:0:\"\";s:10:\"post_types\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:24:\"white_label_cpanel_pages\";a:6:{i:0;s:4:\"home\";i:1;s:7:\"plugins\";i:2;s:9:\"templates\";i:3;s:10:\"image_size\";i:4;s:13:\"system_status\";i:5;s:7:\"updates\";}s:23:\"white_label_cpanel_logo\";s:0:\"\";s:26:\"white_label_text_occurence\";s:0:\"\";s:21:\"white_label_menu_icon\";s:0:\"\";s:22:\"white_label_help_links\";s:1:\"1\";s:21:\"white_label_menu_help\";s:1:\"1\";}","yes");
INSERT INTO JE3LZx3e_options VALUES("283","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.4.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.4.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.4.1\";s:7:\"version\";s:5:\"5.4.1\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1589521823;s:15:\"version_checked\";s:5:\"5.4.1\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO JE3LZx3e_options VALUES("203","current_theme","JupiterX Child","yes");
INSERT INTO JE3LZx3e_options VALUES("204","theme_mods_jupiterx","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1589287083;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:17:\"sidebar_secondary\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}}}}","yes");
INSERT INTO JE3LZx3e_options VALUES("205","theme_switched","","yes");
INSERT INTO JE3LZx3e_options VALUES("225","jupiterx_image_sizes_deleted","a:1:{i:0;i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("226","jupiterx_image_sizes","a:1:{i:0;a:4:{s:6:\"size_n\";s:20:\"Image Size 1000x1000\";s:6:\"size_w\";s:4:\"1000\";s:6:\"size_h\";s:4:\"1000\";s:6:\"size_c\";s:3:\"off\";}}","yes");
INSERT INTO JE3LZx3e_options VALUES("286","_transient_timeout_jupiterx_templates_filters","1589525429","no");
INSERT INTO JE3LZx3e_options VALUES("287","_transient_jupiterx_templates_filters","a:6:{s:8:\"category\";a:16:{s:18:\"creative-portfolio\";s:20:\"Creative / Portfolio\";s:4:\"shop\";s:4:\"Shop\";s:4:\"food\";s:4:\"Food\";s:6:\"events\";s:6:\"Events\";s:12:\"products-app\";s:14:\"Products / App\";s:13:\"blog-magazine\";s:15:\"Blog / Magazine\";s:9:\"corporate\";s:9:\"Corporate\";s:4:\"misc\";s:4:\"Misc\";s:7:\"service\";s:7:\"Service\";s:13:\"health-beauty\";s:19:\"Health &amp; Beauty\";s:6:\"travel\";s:6:\"Travel\";s:13:\"entertainment\";s:13:\"Entertainment\";s:9:\"education\";s:9:\"Education\";s:6:\"sports\";s:6:\"Sports\";s:10:\"non-profit\";s:10:\"Non Profit\";s:17:\"listing-directory\";s:19:\"Listing / Directory\";}s:5:\"style\";a:4:{s:7:\"minimal\";s:7:\"Minimal\";s:4:\"flat\";s:4:\"Flat\";s:7:\"elegant\";s:7:\"Elegant\";s:8:\"parallax\";s:8:\"Parallax\";}s:12:\"content_type\";a:2:{s:8:\"one_page\";s:8:\"One Page\";s:10:\"multi_page\";s:10:\"Multi-Page\";}s:10:\"components\";a:6:{s:9:\"slideshow\";s:9:\"Slideshow\";s:5:\"popup\";s:5:\"Popup\";s:9:\"portfolio\";s:9:\"Portfolio\";s:4:\"blog\";s:4:\"Blog\";s:4:\"shop\";s:4:\"Shop\";s:12:\"booking_form\";s:13:\"Booking Forms\";}s:9:\"menu_type\";a:4:{s:6:\"burger\";s:6:\"Burger\";s:11:\"full_screen\";s:11:\"Full Screen\";s:9:\"mega_menu\";s:9:\"Mega Menu\";s:6:\"normal\";s:6:\"Normal\";}s:11:\"header_type\";a:4:{s:7:\"regular\";s:7:\"Regular\";s:11:\"transparent\";s:11:\"Transparent\";s:8:\"vertical\";s:8:\"Vertical\";s:9:\"multi_row\";s:9:\"Multi Row\";}}","no");
INSERT INTO JE3LZx3e_options VALUES("280","_site_transient_timeout_jupiterx_managed_plugins","1589608220","no");
INSERT INTO JE3LZx3e_options VALUES("281","_site_transient_jupiterx_managed_plugins","a:24:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"Jupiter X Core\";s:4:\"slug\";s:13:\"jupiterx-core\";s:6:\"source\";s:102:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/jupiterx-core-v1.16.0.zip\";s:7:\"version\";s:6:\"1.16.0\";s:8:\"required\";s:4:\"true\";s:3:\"pro\";s:5:\"false\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"Advanced Custom Fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:4:\"true\";s:3:\"pro\";s:5:\"false\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:4:\"true\";s:3:\"pro\";s:5:\"false\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:5:\"Raven\";s:4:\"slug\";s:5:\"raven\";s:6:\"source\";s:93:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/raven-v1.9.4.zip\";s:7:\"version\";s:5:\"1.9.4\";s:8:\"required\";s:4:\"true\";s:3:\"pro\";s:4:\"true\";}i:4;O:8:\"stdClass\":6:{s:4:\"name\";s:12:\"Jet Elements\";s:4:\"slug\";s:12:\"jet-elements\";s:6:\"source\";s:100:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-elements.2.2.14.zip\";s:7:\"version\";s:6:\"2.2.14\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:5;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"Jet Blog\";s:4:\"slug\";s:8:\"jet-blog\";s:6:\"source\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-blog.2.2.5.zip\";s:7:\"version\";s:5:\"2.2.5\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:6;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"Jet Menu\";s:4:\"slug\";s:8:\"jet-menu\";s:6:\"source\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-menu.2.0.4.zip\";s:7:\"version\";s:5:\"2.0.4\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:7;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Jet Popup\";s:4:\"slug\";s:9:\"jet-popup\";s:6:\"source\";s:96:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/03/jet-popup.1.3.1.zip\";s:7:\"version\";s:5:\"1.3.1\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:8;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"Jet Tabs\";s:4:\"slug\";s:8:\"jet-tabs\";s:6:\"source\";s:95:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/jet-tabs.2.1.4.zip\";s:7:\"version\";s:5:\"2.1.4\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:9;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"Jet WooBuilder\";s:4:\"slug\";s:15:\"jet-woo-builder\";s:6:\"source\";s:102:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/03/jet-woo-builder.1.6.2.zip\";s:7:\"version\";s:5:\"1.6.2\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:10;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"Jet Tricks\";s:4:\"slug\";s:10:\"jet-tricks\";s:6:\"source\";s:97:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/03/jet-tricks.1.2.7.zip\";s:7:\"version\";s:5:\"1.2.7\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:11;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"Jet Engine\";s:4:\"slug\";s:10:\"jet-engine\";s:6:\"source\";s:98:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-engine-v2.3.5.zip\";s:7:\"version\";s:5:\"2.3.5\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:12;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"Jet SmartFilters\";s:4:\"slug\";s:17:\"jet-smart-filters\";s:6:\"source\";s:104:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/05/jet-smart-filters.1.7.2.zip\";s:7:\"version\";s:5:\"1.7.2\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:13;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"WPBakery Page Builder (Modified Version)\";s:4:\"slug\";s:17:\"js_composer_theme\";s:6:\"source\";s:113:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/jupiterx_js_composer_theme.6.0.5.zip\";s:7:\"version\";s:5:\"6.0.5\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:14;O:8:\"stdClass\":6:{s:4:\"name\";s:13:\"Jupiter Donut\";s:4:\"slug\";s:13:\"jupiter-donut\";s:6:\"source\";s:101:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2020/04/jupiter-donut-v1.0.6.zip\";s:7:\"version\";s:5:\"1.0.6\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:15;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"source\";s:114:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/advanced-custom-fields-pro-v5.8.7.zip\";s:7:\"version\";s:5:\"5.8.7\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:16;O:8:\"stdClass\":6:{s:4:\"name\";s:23:\"Menu Icons by ThemeIsle\";s:4:\"slug\";s:10:\"menu-icons\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:17;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:6:\"source\";s:96:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/revslider.6.1.5.zip\";s:7:\"version\";s:5:\"6.1.5\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:18;O:8:\"stdClass\":6:{s:4:\"name\";s:13:\"Master Slider\";s:4:\"slug\";s:12:\"masterslider\";s:6:\"source\";s:100:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/masterslider.3.2.14.zip\";s:7:\"version\";s:6:\"3.2.14\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:19;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"LayerSlider WP\";s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"source\";s:106:\"https://d34b8fs2z18t5a.cloudfront.net/wp-content/uploads/dlm_uploads/2019/11/jupiter_LayerSlider.6.9.2.zip\";s:7:\"version\";s:5:\"6.9.2\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:20;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:21;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"Customizer Export/Import\";s:4:\"slug\";s:24:\"customizer-export-import\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:22;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"Customizer Reset\";s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:23;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"WunderWP\";s:4:\"slug\";s:8:\"wunderwp\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}}","no");
INSERT INTO JE3LZx3e_options VALUES("233","theme_mods_jupiterx-child","a:1:{s:18:\"nav_menu_locations\";a:0:{}}","yes");
INSERT INTO JE3LZx3e_options VALUES("223","jet_engine_modules","a:3:{i:0;s:13:\"booking-forms\";i:1;s:18:\"listing-injections\";i:2;s:8:\"calendar\";}","yes");
INSERT INTO JE3LZx3e_options VALUES("214","_transient_timeout_jupiterx_elementor_pages_count","1589888272","no");
INSERT INTO JE3LZx3e_options VALUES("215","_transient_jupiterx_elementor_pages_count","0","no");
INSERT INTO JE3LZx3e_options VALUES("217","widget_jupiterx_social","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("218","widget_jupiterx_posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO JE3LZx3e_options VALUES("285","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1589521824;s:7:\"checked\";a:8:{s:30:\"advanced-custom-fields/acf.php\";s:6:\"5.8.11\";s:21:\"backwpup/backwpup.php\";s:5:\"3.7.1\";s:23:\"elementor/elementor.php\";s:5:\"2.9.8\";s:42:\"hummingbird-performance/wp-hummingbird.php\";s:5:\"2.4.2\";s:31:\"jupiterx-core/jupiterx-core.php\";s:6:\"1.16.0\";s:15:\"raven/raven.php\";s:5:\"1.9.4\";s:31:\"smartcrawl-seo/wpmu-dev-seo.php\";s:5:\"2.6.1\";s:23:\"wp-smushit/wp-smush.php\";s:5:\"3.6.1\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:7:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:6:\"5.8.11\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.5.8.11.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png?rev=1082746\";s:2:\"1x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-128x128.png?rev=1082746\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";}s:11:\"banners_rtl\";a:0:{}}s:21:\"backwpup/backwpup.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:22:\"w.org/plugins/backwpup\";s:4:\"slug\";s:8:\"backwpup\";s:6:\"plugin\";s:21:\"backwpup/backwpup.php\";s:11:\"new_version\";s:5:\"3.7.1\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/backwpup/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/backwpup.3.7.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:61:\"https://ps.w.org/backwpup/assets/icon-256x256.png?rev=1422084\";s:2:\"1x\";s:61:\"https://ps.w.org/backwpup/assets/icon-128x128.png?rev=1422084\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/backwpup/assets/banner-1544x500.png?rev=2153988\";s:2:\"1x\";s:63:\"https://ps.w.org/backwpup/assets/banner-772x250.png?rev=2153988\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"2.9.8\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.2.9.8.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}}s:42:\"hummingbird-performance/wp-hummingbird.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:37:\"w.org/plugins/hummingbird-performance\";s:4:\"slug\";s:23:\"hummingbird-performance\";s:6:\"plugin\";s:42:\"hummingbird-performance/wp-hummingbird.php\";s:11:\"new_version\";s:5:\"2.4.2\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/hummingbird-performance/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/hummingbird-performance.2.4.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/hummingbird-performance/assets/icon-256x256.gif?rev=2262085\";s:2:\"1x\";s:76:\"https://ps.w.org/hummingbird-performance/assets/icon-128x128.gif?rev=2262086\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/hummingbird-performance/assets/banner-1544x500.jpg?rev=1675031\";s:2:\"1x\";s:78:\"https://ps.w.org/hummingbird-performance/assets/banner-772x250.jpg?rev=1675031\";}s:11:\"banners_rtl\";a:0:{}}s:31:\"jupiterx-core/jupiterx-core.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/jupiterx-core\";s:4:\"slug\";s:13:\"jupiterx-core\";s:6:\"plugin\";s:31:\"jupiterx-core/jupiterx-core.php\";s:11:\"new_version\";s:6:\"1.16.0\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/jupiterx-core/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jupiterx-core.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/jupiterx-core/assets/icon-256x256.png?rev=2146738\";s:2:\"1x\";s:66:\"https://ps.w.org/jupiterx-core/assets/icon-256x256.png?rev=2146738\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}s:31:\"smartcrawl-seo/wpmu-dev-seo.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/smartcrawl-seo\";s:4:\"slug\";s:14:\"smartcrawl-seo\";s:6:\"plugin\";s:31:\"smartcrawl-seo/wpmu-dev-seo.php\";s:11:\"new_version\";s:5:\"2.6.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/smartcrawl-seo/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/smartcrawl-seo.2.6.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/smartcrawl-seo/assets/icon-256x256.gif?rev=2262078\";s:2:\"1x\";s:67:\"https://ps.w.org/smartcrawl-seo/assets/icon-128x128.gif?rev=2262078\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/smartcrawl-seo/assets/banner-1544x500.png?rev=1820822\";s:2:\"1x\";s:69:\"https://ps.w.org/smartcrawl-seo/assets/banner-772x250.png?rev=1820822\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"wp-smushit/wp-smush.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/wp-smushit\";s:4:\"slug\";s:10:\"wp-smushit\";s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:11:\"new_version\";s:5:\"3.6.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/wp-smushit/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wp-smushit.3.6.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/wp-smushit/assets/icon-256x256.gif?rev=2263432\";s:2:\"1x\";s:63:\"https://ps.w.org/wp-smushit/assets/icon-128x128.gif?rev=2263431\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wp-smushit/assets/banner-1544x500.png?rev=1863697\";s:2:\"1x\";s:65:\"https://ps.w.org/wp-smushit/assets/banner-772x250.png?rev=1863697\";}s:11:\"banners_rtl\";a:0:{}}}}","no");
INSERT INTO JE3LZx3e_options VALUES("146","new_admin_email","info@rekursiv.fr","yes");
INSERT INTO JE3LZx3e_options VALUES("174","_transient_health-check-site-status-result","{\"good\":\"11\",\"recommended\":\"6\",\"critical\":\"0\"}","yes");



CREATE TABLE `JE3LZx3e_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO JE3LZx3e_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO JE3LZx3e_postmeta VALUES("2","3","_wp_page_template","default");



CREATE TABLE `JE3LZx3e_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO JE3LZx3e_posts VALUES("1","1","2020-05-11 09:56:01","2020-05-11 07:56:01","<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire !</p>\n<!-- /wp:paragraph -->","Bonjour tout le monde !","","publish","open","open","","bonjour-tout-le-monde","","","2020-05-11 09:56:01","2020-05-11 07:56:01","","0","https://preprod.reunion-pathologie.re/?p=1","0","post","","1");
INSERT INTO JE3LZx3e_posts VALUES("2","1","2020-05-11 09:56:01","2020-05-11 07:56:01","<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux visiteurs du site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka-ananas (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules super pour la communauté bouzemontoise.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href=\"https://preprod.reunion-pathologie.re/wp-admin/\">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->","Page d’exemple","","publish","closed","open","","page-d-exemple","","","2020-05-11 09:56:01","2020-05-11 07:56:01","","0","https://preprod.reunion-pathologie.re/?page_id=2","0","page","","0");
INSERT INTO JE3LZx3e_posts VALUES("3","1","2020-05-11 09:56:01","2020-05-11 07:56:01","<!-- wp:heading --><h2>Qui sommes-nous ?</h2><!-- /wp:heading --><!-- wp:paragraph --><p>L’adresse de notre site Web est : https://preprod.reunion-pathologie.re.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Utilisation des données personnelles collectées</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Commentaires</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Quand vous laissez un commentaire sur notre site web, les données inscrites dans le formulaire de commentaire, mais aussi votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Une chaîne anonymisée créée à partir de votre adresse de messagerie (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Médias</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Si vous êtes un utilisateur ou une utilisatrice enregistré·e et que vous téléversez des images sur le site web, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les visiteurs de votre site web peuvent télécharger et extraire des données de localisation depuis ces images.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Formulaires de contact</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Cookies</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse de messagerie et site web dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Contenu embarqué depuis d’autres sites</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p><!-- /wp:paragraph --><!-- wp:heading {\"level\":3} --><h3>Statistiques et mesures d’audience</h3><!-- /wp:heading --><!-- wp:heading --><h2>Utilisation et transmission de vos données personnelles</h2><!-- /wp:heading --><!-- wp:heading --><h2>Durées de stockage de vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Pour les utilisateurs et utilisatrices qui s’enregistrent sur notre site (si cela est possible), nous stockons également les données personnelles indiquées dans leur profil. Tous les utilisateurs et utilisatrices peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur nom d’utilisateur·ice). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Les droits que vous avez sur vos données</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Transmission de vos données personnelles</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Informations de contact</h2><!-- /wp:heading --><!-- wp:heading --><h2>Informations supplémentaires</h2><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Comment nous protégeons vos données</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Procédures mises en œuvre en cas de fuite de données</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Les services tiers qui nous transmettent des données</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Opérations de marketing automatisé et/ou de profilage réalisées à l’aide des données personnelles</h3><!-- /wp:heading --><!-- wp:heading {\"level\":3} --><h3>Affichage des informations liées aux secteurs soumis à des régulations spécifiques</h3><!-- /wp:heading -->","Politique de confidentialité","","draft","closed","open","","politique-de-confidentialite","","","2020-05-11 09:56:01","2020-05-11 07:56:01","","0","https://preprod.reunion-pathologie.re/?page_id=3","0","page","","0");
INSERT INTO JE3LZx3e_posts VALUES("4","1","2020-05-11 09:56:43","0000-00-00 00:00:00","","Brouillon auto","","auto-draft","open","open","","","","","2020-05-11 09:56:43","0000-00-00 00:00:00","","0","https://preprod.reunion-pathologie.re/?p=4","0","post","","0");



CREATE TABLE `JE3LZx3e_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO JE3LZx3e_term_relationships VALUES("1","1","0");



CREATE TABLE `JE3LZx3e_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO JE3LZx3e_term_taxonomy VALUES("1","1","category","","0","1");



CREATE TABLE `JE3LZx3e_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `JE3LZx3e_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO JE3LZx3e_terms VALUES("1","Non classé","non-classe","0");

